

/**
 ******************************************************************************
 *
 * @file        MG32_USBD_HID_API.h
 * @brief       The USBD COM Code's h file.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2024/02/19
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _MG32_USBD_HID_API_H
#define _MG32_USBD_HID_API_H
 
 
/* Includes ----------------------------------------------------------*/
#include "MG32.h" 
#include "MG32_USBD_API.h"
#include "MG32_USBD_Descriptor_API.h"

/* Define ------------------------------------------------------------*/
//Common
#define HID_SUCCESS                      1
#define HID_FAILURE                      0    

//USB module 
#define HID_DATAUPSTREAM_EP                USB_EP1                       /*!< COM upstream data Endpoint.*/
#define HID_DATADOWNSTREAM_EP              USB_EP1                       /*!< COM downstream data Endpoint.*/


#define HID_DATAUPSTREAM_DATASIZE          EP1_PACKET_SIZE               /*!< COM upstream MAX. data size.*/                                                                                                                                               
#define HID_DATADOWNSTREAM_BUFFER_SIZE     EP1_PACKET_SIZE               /*!< MAX size for COM downstream software buffer.*/



/* Typedef -----------------------------------------------------------*/   

/** 
 * @struct	EasyHID_TypeDef
 * @brief	character formatting properties.
 */
typedef struct
{    
    uint8_t   *TxBuf;                                  /*!< Tx buffer pointer.*/
    uint8_t   volatile TxBusyFlag;                              /*!< Tx busy flag.*/
    uint8_t   volatile RxFlag;                                  /*!< Receive flag.*/
    uint8_t   TxLength;                                /*!< Tx total length.*/
    uint8_t   __Padding;                               /*!< Padding byte.*/
}EasyHID_TypeDef;


/* Macro -------------------------------------------------------------*/
/* Exported variables ------------------------------------------------*/
extern EasyHID_TypeDef    eHID_EP;


/* Exported functions ------------------------------------------------*/
void API_HID_Init(void);

uint8_t API_HID_UpstreamData(uint8_t *Upstream_Buf, uint8_t Upstream_Length);
uint8_t API_HID_DownstreamData(uint8_t *Downstream_Buf, uint8_t *Downstream_Length);
void API_HID_UpstreamDataIRQHandler(void);
void API_HID_DownstreamDataIRQHandler(void);



#endif





















